//
//  GSFontInfoValueLocalized.h
//  GlyphsCore
//
//  Created by Georg Seifert on 05.04.19.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSFontInfoProperty.h>
#import <GlyphsCore/GSInstance.h>
#import <GlyphsCore/GSContainerProtocol.h>

@class GSCustomParameter;
@class GSFont;
@class GSFontInfoValue;

NS_ASSUME_NONNULL_BEGIN

@interface GSFontInfoValueLocalized : GSFontInfoProperty <GSContainerProtocol> {
#pragma GSAutoCodeStart ivars

	NSMutableArray<GSFontInfoValue *> *_values;

#pragma GSAutoCodeEnd ivars
}

- (instancetype)initWithKey:(NSString *)key value:(NSString *)value languageTag:(nullable NSString *)languageTag;

- (nullable GSFontInfoValue *)infoValueForLanguageTag:(NSString *)languageTag;

- (nullable NSString *)defaultValue;

#pragma mark - start auto interface
#pragma GSAutoCodeStart methods

#pragma mark Values

/// The values.
@property (nonatomic, strong) NSMutableArray<GSFontInfoValue *> *values;

/** The number of values */
- (NSUInteger)countOfValues;

- (GSFontInfoValue *)objectInValuesAtIndex:(NSUInteger)idx;

- (NSUInteger)indexOfObjectInValues:(GSFontInfoValue *)value;

- (void)addValue:(GSFontInfoValue *)value;

- (void)insertObject:(GSFontInfoValue *)value inValuesAtIndex:(NSUInteger)idx;

- (void)removeObjectFromValues:(GSFontInfoValue *)value;

/** Removes the value at idx

 @param idx The index
 */
- (void)removeObjectFromValuesAtIndex:(NSUInteger)idx;

#pragma GSAutoCodeEnd methods

+ (NSMutableArray<GSFontInfoValue *> *)fontInfoValuesFromDicts:(NSArray<NSDictionary *> *)list format:(GSFormatVersion)formatVersion;

+ (NSMutableArray<NSDictionary *> *)propertyListFromFontInfoValues:(NSArray<GSFontInfoValue *> *)list format:(GSFormatVersion)formatVersion;

#ifndef LIBCORE
+ (nullable NSArray<GSCustomParameter *> *)legacyCustomParametersFromProperties:(NSArray <GSFontInfoProperty *> *)properties object:(GSFont *)object error:(NSError **)error;

+ (void)loadLegacyCustomParameters:(NSArray<GSCustomParameter *> *)parameters parent:(GSFont *)parent;
#endif

@end

NS_ASSUME_NONNULL_END
